/*
 * Decompiled with CFR 0.152.
 */
package UserInterface;

import UserInterface.GameBoard;
import UserInterface.SmartSquare;

public class CheckSquare {
    private GameBoard board;
    private int boardHeight;
    private int boardWidth;
    private static final int[] distantX = new int[]{-1, 0, 1};
    private static final int[] distantY = new int[]{-1, 0, 1};

    public CheckSquare(GameBoard board) {
        this.board = board;
        this.boardHeight = (board.getHeight() - 20) / 20;
        this.boardWidth = (board.getWidth() - 20) / 20;
    }

    private boolean hasKickedBoundary(int x, int y) {
        return x < 0 || x >= this.boardWidth || y < 0 || y >= this.boardHeight;
    }

    protected boolean isSuccess() {
        int count = 0;
        for (int y = 0; y < this.boardHeight; ++y) {
            for (int x = 0; x < this.boardWidth; ++x) {
                if (!((SmartSquare)this.board.getSquareAt(x, y)).getTraverse()) continue;
                ++count;
            }
        }
        return count == this.boardHeight * this.boardWidth;
    }

    protected void showBomb(int currentX, int currentY) {
        for (int y = 0; y < this.boardHeight; ++y) {
            for (int x = 0; x < this.boardWidth; ++x) {
                if (currentX == x && currentY == y) continue;
                if (((SmartSquare)this.board.getSquareAt(x, y)).getBombExist()) {
                    this.board.getSquareAt(x, y).setImage(CheckSquare.class.getResource("/bomb.png"));
                    continue;
                }
                if (!((SmartSquare)this.board.getSquareAt(x, y)).getGuessThisSquareIsBomb()) continue;
                this.board.getSquareAt(x, y).setImage(CheckSquare.class.getResource("/flagWrong.png"));
            }
        }
    }

    protected void countBomb(int currentX, int currentY) {
        int count = 0;
        if (this.hasKickedBoundary(currentX, currentY)) {
            return;
        }
        if (((SmartSquare)this.board.getSquareAt(currentX, currentY)).getTraverse()) {
            return;
        }
        SmartSquare currentObject = (SmartSquare)this.board.getSquareAt(currentX, currentY);
        currentObject.setTraverse(true);
        for (int x : distantX) {
            for (int y : distantY) {
                if (this.hasKickedBoundary(currentX + x, currentY + y) || x == 0 && y == 0) continue;
                SmartSquare squareObject = (SmartSquare)this.board.getSquareAt(currentX + x, currentY + y);
                count = squareObject.getBombExist() ? count + 1 : count;
            }
        }
        if (count != 0) {
            currentObject.setImage(CheckSquare.class.getResource("/" + count + ".png"));
        } else {
            currentObject.setImage(CheckSquare.class.getResource("/0.png"));
            this.countBomb(currentX - 1, currentY - 1);
            this.countBomb(currentX, currentY - 1);
            this.countBomb(currentX + 1, currentY - 1);
            this.countBomb(currentX - 1, currentY);
            this.countBomb(currentX + 1, currentY);
            this.countBomb(currentX - 1, currentY + 1);
            this.countBomb(currentX, currentY + 1);
            this.countBomb(currentX + 1, currentY + 1);
        }
    }
}

