/*
 * Decompiled with CFR 0.152.
 */
package UserInterface;

import UserInterface.GameSquare;
import UserInterface.SmartSquare;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GameBoard
extends JFrame
implements ActionListener {
    private JPanel boardPanel = new JPanel();
    private int boardHeight;
    private int boardWidth;
    private GameSquare[][] board;

    public GameBoard(String title, int width, int height) {
        this.boardWidth = width;
        this.boardHeight = height;
        this.board = new GameSquare[width][height];
        this.setTitle(title);
        this.setSize(20 + width * 20, 20 + height * 20);
        this.setContentPane(this.boardPanel);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.boardPanel.setLayout(new GridLayout(height, width));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.board[x][y] = new SmartSquare(x, y, this);
                this.board[x][y].addActionListener(this);
                this.boardPanel.add(this.board[x][y]);
            }
        }
        this.setVisible(true);
    }

    public GameSquare getSquareAt(int x, int y) {
        if (x < 0 || x >= this.boardWidth || y < 0 || y >= this.boardHeight) {
            return null;
        }
        return this.board[x][y];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GameSquare b = (GameSquare)e.getSource();
        b.clicked();
    }
}

