/*
 * Decompiled with CFR 0.152.
 */
package UserInterface;

import UserInterface.GameBoard;
import UserInterface.ProduceBombs;
import UserInterface.SmartSquare;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Menu
extends JFrame
implements ActionListener {
    private JButton start;
    private JRadioButton beginner;
    private JRadioButton intermediate;
    private JRadioButton advanced;
    private JRadioButton custom;
    private JTextField width;
    private JTextField height;
    private JTextField mines;

    public Menu(String title) {
        this.setTitle(title);
        JLabel subtitle = new JLabel("Difficulty");
        subtitle.setBounds(100, 10, 100, 20);
        this.add(subtitle);
        this.beginner = new JRadioButton("Beginner");
        this.beginner.setBounds(40, 40, 150, 20);
        this.add(this.beginner);
        JLabel bDescFirstLine = new JLabel("10 mines");
        bDescFirstLine.setBounds(70, 60, 100, 20);
        JLabel bDescSecondLine = new JLabel("10 x 10 tile grid");
        bDescSecondLine.setBounds(70, 80, 100, 20);
        this.add(bDescFirstLine);
        this.add(bDescSecondLine);
        this.intermediate = new JRadioButton("Intermediate");
        this.intermediate.setBounds(40, 100, 150, 20);
        this.add(this.intermediate);
        JLabel iDescFirstLine = new JLabel("40 mines");
        iDescFirstLine.setBounds(70, 120, 100, 20);
        JLabel iDescSecondLine = new JLabel("16 x 16 tile grid");
        iDescSecondLine.setBounds(70, 140, 100, 20);
        this.add(iDescFirstLine);
        this.add(iDescSecondLine);
        this.advanced = new JRadioButton("Advanced");
        this.advanced.setBounds(40, 160, 160, 20);
        this.add(this.advanced);
        JLabel aDescFirstLine = new JLabel("100 mines");
        aDescFirstLine.setBounds(70, 180, 100, 20);
        JLabel aDescSecondLine = new JLabel("30 x 25 tile grid");
        aDescSecondLine.setBounds(70, 200, 100, 20);
        this.add(aDescFirstLine);
        this.add(aDescSecondLine);
        this.custom = new JRadioButton("Custom");
        this.custom.setBounds(40, 220, 100, 20);
        this.add(this.custom);
        JLabel widthLabel = new JLabel("Width (10-30):");
        widthLabel.setBounds(70, 240, 80, 20);
        this.add(widthLabel);
        this.width = new JTextField();
        this.width.setBounds(170, 240, 40, 20);
        this.add(this.width);
        JLabel heightLabel = new JLabel("height (10-25):");
        heightLabel.setBounds(70, 260, 90, 20);
        this.add(heightLabel);
        this.height = new JTextField();
        this.height.setBounds(170, 260, 40, 20);
        this.add(this.height);
        JLabel mineLabel = new JLabel("Mines (10-100):");
        mineLabel.setBounds(70, 280, 90, 20);
        this.add(mineLabel);
        this.mines = new JTextField();
        this.mines.setBounds(170, 280, 40, 20);
        this.add(this.mines);
        this.start = new JButton("New Game");
        this.start.setBounds(80, 320, 100, 20);
        this.add(this.start);
        this.width.setEditable(false);
        this.height.setEditable(false);
        this.mines.setEditable(false);
        this.custom.addActionListener(this);
        this.beginner.addActionListener(this);
        this.intermediate.addActionListener(this);
        this.advanced.addActionListener(this);
        this.start.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.beginner);
        group.add(this.intermediate);
        group.add(this.advanced);
        group.add(this.custom);
        this.beginner.setSelected(true);
        this.setSize(280, 400);
        this.setLayout(null);
        this.setVisible(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.custom) {
            this.width.setEditable(true);
            this.height.setEditable(true);
            this.mines.setEditable(true);
        } else if (e.getSource() == this.start) {
            int boardWidth = 0;
            int boardHeight = 0;
            int bombs = 0;
            boolean errorFlag = false;
            if (this.beginner.isSelected()) {
                boardWidth = 10;
                boardHeight = 10;
                bombs = 10;
            } else if (this.intermediate.isSelected()) {
                boardWidth = 16;
                boardHeight = 16;
                bombs = 40;
            } else if (this.advanced.isSelected()) {
                boardWidth = 30;
                boardHeight = 25;
                bombs = 100;
            } else if (!this.checkValid(this.width.getText(), this.height.getText(), this.mines.getText())) {
                errorFlag = true;
                JOptionPane.showMessageDialog(null, "Please enter correct numbers!");
            } else {
                boardWidth = Integer.parseInt(this.width.getText());
                boardHeight = Integer.parseInt(this.height.getText());
                bombs = Integer.parseInt(this.mines.getText());
            }
            if (!errorFlag) {
                this.dispose();
                GameBoard b = new GameBoard("Minesweeper", boardWidth, boardHeight);
                new ProduceBombs(b, bombs);
                ((SmartSquare)b.getSquareAt(0, 0)).setStartTime(System.currentTimeMillis());
            }
        } else {
            this.width.setEditable(false);
            this.height.setEditable(false);
            this.mines.setEditable(false);
        }
    }

    private boolean checkValid(String bWidth, String bHeight, String bomb) {
        Pattern pattern = Pattern.compile("[0-9]*");
        if (bWidth == null || bHeight == null || bomb == null) {
            return false;
        }
        if (bWidth.isEmpty() || bHeight.isEmpty() || bomb.isEmpty()) {
            return false;
        }
        if (!(pattern.matcher(bWidth).matches() && pattern.matcher(bHeight).matches() && pattern.matcher(bomb).matches())) {
            return false;
        }
        if (Integer.parseInt(bWidth) < 10 || Integer.parseInt(bWidth) > 30 || Integer.parseInt(bHeight) < 10 || Integer.parseInt(bHeight) > 25 || Integer.parseInt(bomb) < 10 || Integer.parseInt(bomb) > 100) {
            return false;
        }
        return Integer.parseInt(bWidth) * Integer.parseInt(bHeight) >= Integer.parseInt(bomb);
    }
}

