/*
 * Decompiled with CFR 0.152.
 */
package UserInterface;

import Library.TimeChecker;
import UserInterface.CheckSquare;
import UserInterface.GameBoard;
import UserInterface.GameSquare;
import UserInterface.Menu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class SmartSquare
extends GameSquare
implements MouseListener,
TimeChecker {
    private boolean thisSquareHasBomb;
    private boolean guessThisSquareIsBomb;
    private boolean thisSquareHasTraversed;
    private int xLocation;
    private int yLocation;
    private long startTime;

    public SmartSquare(int x, int y, GameBoard board) {
        super(x, y, SmartSquare.class.getResource("/block.png"), board);
        this.xLocation = x;
        this.yLocation = y;
        this.thisSquareHasBomb = false;
        this.thisSquareHasTraversed = false;
        this.guessThisSquareIsBomb = false;
        this.startTime = 0L;
        this.addMouseListener(this);
    }

    protected void setBombExist(boolean result) {
        this.thisSquareHasBomb = result;
    }

    protected boolean getBombExist() {
        return this.thisSquareHasBomb;
    }

    protected boolean getTraverse() {
        return this.thisSquareHasTraversed;
    }

    protected void setTraverse(boolean result) {
        this.thisSquareHasTraversed = result;
    }

    protected boolean getGuessThisSquareIsBomb() {
        return this.guessThisSquareIsBomb;
    }

    protected void setStartTime(long time) {
        this.startTime = time;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    @Override
    public void clicked() {
        CheckSquare cq = new CheckSquare(this.board);
        this.guessThisSquareIsBomb = false;
        if (this.thisSquareHasBomb) {
            this.setImage(SmartSquare.class.getResource("/bombReveal.png"));
            long costTime = System.currentTimeMillis() - ((SmartSquare)this.board.getSquareAt(0, 0)).getStartTime();
            cq.showBomb(this.xLocation, this.yLocation);
            this.window("You used " + TimeChecker.calculateTime(costTime) + ". Do you want to try again?", "Game Over", new ImageIcon(SmartSquare.class.getResource("/failFace.png")));
        } else {
            this.thisSquareHasTraversed = false;
            cq.countBomb(this.xLocation, this.yLocation);
            if (cq.isSuccess()) {
                long costTime = System.currentTimeMillis() - ((SmartSquare)this.board.getSquareAt(0, 0)).getStartTime();
                cq.showBomb(this.xLocation, this.yLocation);
                this.window("You win this game in " + TimeChecker.calculateTime(costTime) + "! Do you want to try again?", "Congratulations", new ImageIcon(SmartSquare.class.getResource("/passFace.jpg")));
            }
        }
    }

    public void window(String msg, String title, Icon img) {
        int choose = JOptionPane.showConfirmDialog(this.board, msg, title, 0, 3, img);
        if (choose == 0) {
            new Menu("Mine sweeper");
        }
        this.board.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            int clickCount = e.getClickCount();
            if (clickCount == 1) {
                this.setImage(SmartSquare.class.getResource("/redFlag.png"));
                this.guessThisSquareIsBomb = true;
            }
            if (clickCount == 2) {
                this.setImage(SmartSquare.class.getResource("/questionMark.png"));
                this.guessThisSquareIsBomb = false;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

